/*jslint node: true, nomen: true, unparam: true */
/*global jquery, $, _, define, Marionette, jqm, window */

'use strict';

define([ 'Portal', 'backbone', 'marionette', 'jquery', 'core/models/Model', 'hbs!modules/subject-info/subjectInfo'],
    function (Portal, Backbone, Marionette, $, Model, template) {
        return Backbone.Marionette.ItemView.extend({
            template : template,
            tagName: 'div',
            id: 'subject-info-window',
            attributes: {
                'data-role':'popup',
                role: 'dialog'
            },
            model: Portal.patient(),
            initialize : function () {
                var that = this;
                Portal.commands.setHandler("open-subject-info", function(){
                    that.openInfo();
                });
                Portal.vent.on('close:popups', function () {
                    that.closeMessages();
                }); 
            },
            modelEvents: {
                'change': 'render'
            },
            onRender : function () {
                this.$el.popup({
                    shadow: true,                  // Shadow around popup
                    transition: "fade",            // How to animate in.
                    corners: false,                // No rounded Edges
                    tolerance: "41,0",             // Edges from window
                    dismissible: true,             // Click anywhere to close.
                    overlayTheme: 'a'
                });
            },
            openInfo: function () {
                this.$el.popup('open');
                this.$el.focus();
            },
            closeMessages: function () {
               $('#'+this.id).popup('close');
            }
        });
    });
